using log4net;
using Microsoft.Azure.WebJobs;
using Microsoft.Azure.WebJobs.Extensions.Http;
using System;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Net.Http.Formatting;
using System.Threading.Tasks;
using VA.PPMS.IWS.AddressValidationService.Interface;
using VA.PPMS.IWS.Common;

namespace VA.PPMS.IWS.Functions
{
    public static class ValidateAddress
    {
        [FunctionName("ValidateAddress")]
        public static async Task<HttpResponseMessage> Run([HttpTrigger(AuthorizationLevel.Anonymous, "get", Route = "ValidateAddress/v1")]HttpRequestMessage req,
            [Inject]IAddressValidationService addressValidationService,
            [Inject]ILog logger)
        {
            try
            {
                var streetAddress = req.GetQueryNameValuePairs().FirstOrDefault(x => string.Compare(x.Key, "streetAddress", StringComparison.OrdinalIgnoreCase) == 0).Value;
                var city = req.GetQueryNameValuePairs().FirstOrDefault(x => string.Compare(x.Key, "city", StringComparison.OrdinalIgnoreCase) == 0).Value;
                var state = req.GetQueryNameValuePairs().FirstOrDefault(x => string.Compare(x.Key, "state", StringComparison.OrdinalIgnoreCase) == 0).Value;
                var zip = req.GetQueryNameValuePairs().FirstOrDefault(x => string.Compare(x.Key, "zip", StringComparison.OrdinalIgnoreCase) == 0).Value;

                var request = new RootObjectRequest
                {
                    requestAddress = new Address
                    {
                        addressLine1 = streetAddress,
                        city = city,
                        stateProvince = new StateProvince
                        {
                            name = state
                        },
                        zipCode5 = zip
                    }
                };

                var response = await addressValidationService.ValidateAddress(request);

                if (response != null) return req.CreateResponse(HttpStatusCode.OK, response, new JsonMediaTypeFormatter { UseDataContractJsonSerializer = true });

                logger.Error("@@@@ ERROR - The response returned from the Address Validation Service is null");
                return req.CreateErrorResponse(HttpStatusCode.InternalServerError, "Error: ValidateAddress Function API - Null response returned from Address Validation Service");
            }
            catch (Exception ex)
            {
                logger.Error("An error occurred in the ValidateAddress Function API: ", ex);
                return req.CreateErrorResponse(HttpStatusCode.InternalServerError, "An error occurred in the ValidateAddress Function API: ", ex);
            }            
        }
    }
}